#--------------------------------------------------------------------------------------#
# Program Name   : Chapter2_Section2.11.7
#---------------------------------------------------------------------------------------#
start.time <- proc.time()[3]
library(lme4)
library(nlme)
require(lattice)

lot <- c(rep("A", 6), rep("B", 6), rep("C",6))
vialn <- seq(1, 18, 1)
month <- rep(seq(0, 30, 6), 3)
conc <- c(102.1, 101.4, 101, 101.1, 100.8, 
          99.6, 100, 100, 100.2, 98.8, 99.8, 
          99, 97.6, 98.3, 98.1, 97.1, 96.5, 96)

table243.ds <- data.frame(Lot = lot, Vial = vialn, Concentration = conc, Time = month)  
table243.ds


table243.fit <- lmer(Concentration~ Time +(1|Lot), data = table243.ds) 
summary(table243.fit)
coef(table243.fit)
ranef(table243.fit)



newds <- data.frame(Lot="A", Time=30, Concentration=0)
predict(table243.fit, newds )
predict(table243.fit, newds, re.form=NA)



cat("\n"); cat("Time Elapsed (hour): ", (proc.time()[3]-start.time)/3600, "\n")
rm(list=ls(all=TRUE))
#---------------------------------------------------------------------------------------#
#                                End of script
#---------------------------------------------------------------------------------------#